/**
* \file: helper.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: authorization level daemon
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef ALD_UTIL_HELPER_H
#define ALD_UTIL_HELPER_H

#include "ald_types.h"

#define STRCRPLC_MAX_LEN_UNLIMITED -1


void helper_strcrplc(char *string, const char find_char, const char rplc_char, size_t max_len);

bool helper_does_string_contain_token(const char *string, const char *token_to_find, const char *delimiters);

char *helper_trim(char *string, bool *is_empty);

void helper_remove_trailing_slash_from_path(char *value);

error_code_t helper_extract_kv_from_line(char *clean_line,char **key, char **value,int line_no);



void helper_items_init(cfg_item_t *const items[], size_t items_cnt);

void helper_items_free(cfg_item_t *const items[], size_t items_cnt);



error_code_t helper_item_set(cfg_item_t *item, const char *value);

const char *helper_get_str_value(cfg_item_t *item);

logger_loglevel_t helper_get_loglevel(cfg_item_t *item);

uint32_t helper_get_U32_value(cfg_item_t *item);

bool helper_get_flag(cfg_item_t *item);

const char *helper_get_str_default(const cfg_item_spec_t *spec);

uint32_t helper_get_U32_default(const cfg_item_spec_t *spec);

error_code_t helper_find_parse_init_command(
                                          size_t argc, char *argv[],
                                          command_vtable_t *commands[],
                                          size_t commands_len,
                                          const char *binary_name,
                                          void (*print_help)(
                                                  const char *binary_name,
                                                  command_vtable_t *commands[],
                                                  size_t commands_len),
                                          void (*print_version)(const char *binary_name),
                                          void (*print_usage)(const char *binary_name),
                                          command_vtable_t **current_cmd);

void helper_sync_parent_directory(const char *fn);
#endif

